# IAnonym — Extensions Chrome et Firefox

Ce dossier contient deux versions du **pseudonymiseur de documents** pour usage local et hors-ligne.

## 📂 Structure des répertoires

```
IAnonym/
├── IAnonym-Chrome/
│   ├── manifest.json
│   ├── popup.html
│   ├── app.html (page onglet Firefox optionnelle)
│   ├── styles.css
│   ├── dist/
│   │   ├── popup.js
│   │   ├── utils.js
│   │   ├── libs.js
│   │   ├── pseudonymizer.js
│   │   ├── pdf.mjs
│   │   ├── pdf.worker.min.js
│   │   └── mammoth.browser.js
│   ├── assets/
│   │   ├── icon16.png
│   │   ├── icon48.png
│   │   └── icon128.png
│   ├── 01-fetch-libs.ps1
│   └── 01-fetch-libs.bat
│
└── IAnonym-Firefox/
    ├── manifest.json
    ├── popup.html
    ├── app.html
    ├── styles.css
    ├── dist/ (mêmes fichiers que ci-dessus)
    ├── assets/ (mêmes icônes)
    ├── 01-fetch-libs.ps1
    └── 01-fetch-libs.bat
```

---

## 🧩 Installation sur le poste utilisateur final

### Préparation : Si les fichiers `pdf.mjs`, `pdf.worker.min.js` ou `mammoth.browser.js` ne sont pas présents dans dist
1. Dézippez le dossier `IAnonym` à un emplacement de votre choix.  
2. Ouvrez le dossier correspondant à votre navigateur (`IAnonym-Chrome` ou `IAnonym-Firefox`).
3. **Exécutez une seule fois** le script :
   - `01-fetch-libs.ps1` *(clic droit → “Exécuter avec PowerShell”)*  
   **ou**, si PowerShell est restreint : `01-fetch-libs.bat`  
   → cela télécharge `pdf.mjs`, `pdf.worker.min.js` et `mammoth.browser.js` dans `dist/`.

Une fois ces fichiers présents, **l’extension fonctionne entièrement hors-ligne**.

---

### Installation de l’extension

#### 🟦 Chrome / Edge
1. Ouvrez `chrome://extensions` (ou `edge://extensions`).
2. Activez le **Mode développeur** (coin supérieur droit).
3. Cliquez sur **Charger l’extension non empaquetée**.
4. Sélectionnez le dossier `IAnonym-Chrome`.
5. L’icône “IAnonym” apparaît dans la barre d’outils.

#### 🦊 Firefox
1. Ouvrez `about:debugging#/runtime/this-firefox`.
2. Cliquez sur **Load Temporary Add-on…**.
3. Sélectionnez le fichier `manifest.json` dans le dossier `IAnonym-Firefox`.
4. L’icône “IAnonym” apparaît dans la barre d’outils.

---

## ⚙️ Utilisation

1. Cliquez sur l’icône **IAnonym** dans la barre d’outils.  
   - Sur **Firefox**, un onglet `app.html` s’ouvre automatiquement (popup persistant).  
   - Sur **Chrome**, l’interface s’ouvre directement dans le popup.
2. Cliquez sur **“Choisir un fichier…”** et sélectionnez un document :  
   - Formats pris en charge : **PDF**, **DOCX**, **Markdown (.md)**, **TXT**.
3. Cliquez sur **“Générer le Markdown pseudonymisé”**.  
   L’analyse se fait **localement** (aucune donnée transmise).  
4. Le texte pseudonymisé et le **tableau de correspondance** s’affichent dans la zone d’aperçu.  
5. Cliquez sur **“Télécharger le .md”** pour enregistrer le résultat.

---

## 🧠 Règles d’anonymisation appliquées

| Type | Règle |
|------|--------|
| Noms / Prénoms | Remplacés par `Agent <numéro>` |
| Fonctions | Remplacées par `Poste <lettre>` |
| Adresses IP | Remplacées par `IP-<numéro>` |
| Services | Remplacés par `Service <lettre>` |
| Noms de lieux | Remplacés par `Lieu <lettre>` |
| Acronymes (seuls ou “+ Région”) | Remplacés par `ORG <lettre>` |
| Emails | Remplacés par `Mail <lettre>` |

Le tableau de correspondance est ajouté en fin de document sous forme de **table Markdown**.

---

## 🔒 Sécurité et confidentialité

- Aucun envoi de données : le traitement est **100 % local**.  
- Les fichiers choisis restent uniquement en mémoire du navigateur.  
- L’outil peut fonctionner **sans Internet** une fois les bibliothèques téléchargées.

---

## 🆘 En cas de problème
- Si l’interface disparaît au choix de fichier sur Firefox → utilisez la version **onglet (app.html)**.  
- Si le tableau Markdown affiche des `\n` → remplacez-les par de vrais retours à la ligne (correctif inclus dans la version récente).  
- Si les fichiers `pdf.mjs`, `pdf.worker.min.js` ou `mammoth.browser.js` manquent → relancez `01-fetch-libs.ps1`.
- En cas de besoin, compléter le formulaire à l'adresse suivante : [https://promptotheque.piag.din.gouv.fr/partage/](https://promptotheque.piag.din.gouv.fr/partage/)

---
