# 01-fetch-libs.ps1 — Télécharge pdf.js + worker + mammoth dans dist/ (une fois suffit)
$ErrorActionPreference = "Stop"
$here = Split-Path -Parent $MyInvocation.MyCommand.Path
$dist = Join-Path $here "dist"
New-Item -ItemType Directory -Force -Path $dist | Out-Null

$PDF_MJS_URL    = "https://unpkg.com/pdfjs-dist@4.4.168/build/pdf.mjs"
$PDF_WORKER_URL = "https://unpkg.com/pdfjs-dist@4.4.168/build/pdf.worker.min.mjs"
$MAMMOTH_URL    = "https://unpkg.com/mammoth@1.6.0/mammoth.browser.js"

Invoke-WebRequest -Uri $PDF_MJS_URL -OutFile (Join-Path $dist "pdf.mjs")
Invoke-WebRequest -Uri $PDF_WORKER_URL -OutFile (Join-Path $dist "pdf.worker.min.js")
Invoke-WebRequest -Uri $MAMMOTH_URL -OutFile (Join-Path $dist "mammoth.browser.js")

Write-Host "✅ Libs prêtes dans dist/. L’extension fonctionne hors-ligne." -ForegroundColor Green
