import { readFileAsText, sniffExt, extractTextDocx, extractTextPdf } from './utils.js';
import { pseudonymizeToMarkdown } from './pseudonymizer.js';
const fileInput=document.getElementById('fileInput');const runBtn=document.getElementById('runBtn');const preview=document.getElementById('preview');const statusEl=document.getElementById('status');const downloadBtn=document.getElementById('downloadBtn');let file;
fileInput.addEventListener('change',()=>{file=fileInput.files&&fileInput.files[0];runBtn.disabled=!file;preview.value='';downloadBtn.disabled=true;statusEl.textContent=file?`Fichier choisi : ${file.name}`:'';});
runBtn.addEventListener('click',async()=>{if(!file)return;statusEl.textContent='Traitement en cours…';try{const ext=sniffExt(file.name);let text='';if(ext==='txt'||ext==='md'||ext==='markdown'){text=await readFileAsText(file);}else if(ext==='docx'){text=await extractTextDocx(file);}else if(ext==='pdf'){text=await extractTextPdf(file);}else{throw new Error('Format non supporté.');}
const {markdown,mapping}=pseudonymizeToMarkdown(text);preview.value=markdown;statusEl.textContent=`Terminé. ${mapping.length} entrées dans le tableau de correspondance.`;downloadBtn.disabled=false;downloadBtn.onclick=()=>{const blob=new Blob([markdown],{type:'text/markdown;charset=utf-8'});const url=URL.createObjectURL(blob);const a=document.createElement('a');const base=file.name.replace(/\.[^.]+$/,'')||'sortie';a.href=url;a.download=base+'-pseudonymise.md';a.click();URL.revokeObjectURL(url);};}catch(e){console.error(e);statusEl.textContent='Erreur : '+e.message+' — Avez-vous exécuté 01-fetch-libs.ps1 ?';}});
