# Convertisseur PDF et EML

# Guide d’installation — **PDF & EML → Texte/JSON** (Chrome/Edge & Firefox)

Ce module complémentaire extrait **uniquement le texte** depuis des fichiers **PDF** et **EML** (format natif pour les emails) et permet d’enregistrer le résultat en **.txt** ou **.json**.
Il fonctionne **localement** : aucun envoi de données vers un serveur.

---

## 1) Pré-requis

* Un navigateur **Chrome/Edge** (version récente) **ou** **Firefox**.
* L’archive de l’extension (dossier ou `.zip`) à décompresser sur votre ordinateur.
* **Pour convertir des PDF uniquement** : vérifiez que les 2 fichiers suivants sont bien présents :

  * `lib/pdfjs/pdf.mjs`
  * `lib/pdfjs/pdf.worker.mjs`

  > Sans ces deux fichiers, la conversion **EML** fonctionnera quand même, mais pas la partie **PDF**.

---

## 2) Installation sur **Chrome / Edge** (mode développeur)

1. **Décompressez** l’archive de l’extension dans un dossier (par ex. `pdf-eml-text-exporter`).
2. Ouvrez `chrome://extensions/` (ou `edge://extensions/`).
3. **Activez** le **Mode développeur** (coin supérieur droit).
4. Cliquez sur **Charger l’extension non empaquetée** et **sélectionnez le dossier** de l’extension.
5. L’icône **“PDF & EML → Texte/JSON”** apparaît dans la barre d’outils.

---

## 3) Installation sur **Firefox** (module temporaire)

1. **Décompressez** l’archive dans un dossier.
2. Ouvrez `about:debugging#/runtime/this-firefox`.
3. Cliquez **Charger un module complémentaire temporaire** et **choisissez** le fichier `manifest.json` (dans le dossier).
4. L’icône apparaît dans la barre d’outils.

> Pour une installation **durable** (non temporaire), l’extension doit être **signée**. Contactez votre support ou suivez la procédure AMO (addons.mozilla.org) pour empaqueter et signer l’extension.

---

## 4) Utilisation

1. Cliquez sur l’icône **PDF & EML → Texte/JSON**.
2. Dans la fenêtre (popup) :

   * **Choisissez un fichier** `.pdf` ou `.eml`.
   * Sélectionnez le **format de sortie** : **Texte** ou **JSON**.
   * Cliquez **Convertir**.
3. Le **résultat** s’affiche dans la zone “Résultat”.
4. Cliquez **Enregistrer…** pour télécharger le fichier de sortie (`.txt` ou `.json`).

**Comportement attendu**

* **PDF** : chaque page commence par `----------- Page N`. Le texte conserve les retours à la ligne (meilleure préservation des titres/sections).
* **EML** : seules les **parties texte** sont extraites.

  * **Ignorés** : **pièces jointes** et **images base64**.
  * Si le message est HTML, les balises **`<h1..h6>`** sont converties en **lignes de titre** (majuscules), et le **Subject** devient un **titre** en tête.

---

## 5) Formats de sortie

* **Texte (.txt)**

  * **PDF** :

    ```
    ----------- Page 1
    … contenu page 1 …

    ----------- Page 2
    … contenu page 2 …
    ```
  * **EML** :

    ```
    ----------- Page 1
    == Sujet du message ==

    … corps du message (HTML converti en texte, titres en majuscules) …
    ```

* **JSON (.json)**

  * **PDF** :

    ```json
    {
      "type": "pdf",
      "pages": ["----------- Page 1\n…", "----------- Page 2\n…"],
      "pageCount": 2
    }
    ```
  * **EML** :

    ```json
    {
      "type": "eml",
      "headers": { "from": "...", "subject": "...", "content-type": "..." },
      "text": "----------- Page 1\n== Sujet ==\n\n…"
    }
    ```

---

## 6) Confidentialité & sécurité

* Tout le traitement s’effectue **localement** dans votre navigateur.
* **Aucune** donnée n’est envoyée vers Internet.
* Les **pièces jointes** et **images encodées** des EML sont **ignorées** conformément à la politique de l’outil.

---

## 7) Dépannage (FAQ)

**Le bouton “Convertir” reste grisé**

* Sélectionnez un fichier `.pdf` ou `.eml`. Une fois le fichier choisi, le bouton s’active.
* Si rien ne réagit, rechargez l’extension (Chrome/Edge : `chrome://extensions/` → “Actualiser”).

**Message “PDF.js introuvable”**

* Copiez `lib/pdfjs/pdf.mjs` et `lib/pdfjs/pdf.worker.mjs` (voir §4) puis **actualisez** l’extension.
* Les **EML** fonctionnent même sans PDF.js.

**Le bouton “Enregistrer…” reste grisé**

* Il ne s’active **qu’après une conversion réussie**. Lancez **Convertir** puis réessayez.
* Si le format “JSON” est sélectionné **après** la conversion, le bouton reste actif.

**Le téléchargement ne démarre pas**

* Sur certains environnements, l’enregistrement dans un **popup** nécessite la permission **Téléchargements** :

  * Chrome/Edge : vérifiez dans la fiche de l’extension que la permission est **accordée**.
* En cas de blocage par la politique de l’entreprise, utilisez la version empaquetée et approuvée par l’administrateur.

**Le rendu texte est “écrasé” ou mal espacé**

* Les PDF complexes restent délicats à linéariser. L’outil **n’effectue pas d’OCR** : il lit uniquement le **texte natif**.
* Essayez de réexporter le PDF (imprimante PDF) pour obtenir un texte plus propre.

---

## 8) Mise à jour

* **Chrome/Edge** : remplacez le dossier par la nouvelle version puis cliquez **Actualiser** dans `chrome://extensions/`.
* **Firefox (temporaire)** : rechargez le module avec le nouveau `manifest.json`.
* Les **fichiers PDF.js** peuvent être réutilisés tels quels si la version reste compatible.

---

## 9) Désinstallation

* **Chrome/Edge** : `chrome://extensions/` → **Supprimer** sur la carte de l’extension.
* **Firefox** : `about:addons` → **Supprimer**.

---

### Support utilisateur

* Problème lors de l’enregistrement ou d’un clic bloqué ? Vérifiez la permission **Téléchargements** et réessayez.
* Conversion PDF en échec ? Assurez-vous que `lib/pdfjs/pdf.mjs` et `lib/pdfjs/pdf.worker.mjs` sont présents, puis **rechargez** l’extension.

Vous pouvez également nous adresser un message via le [formulaire de contact](https://promptotheque.piag.din.gouv.fr/partage) de la Promptothèque.
