**MEASURE 22**

# **Providing local authorities with the information necessary to adapt their territory to climate change**

|MEASURE CATEGORY|CONTEXT|
|---|---|
|2. Ensuring the resilience of territories, infrastructures, and essential services|The objective of this measure is to provide local authorities with the information they need on future climate and its impacts on their territory to build their climate change adaptation strategy.|

### **ACTIONS ALREADY UNDERTAKEN**

As part of the second PNACC, a resource center on [climate change adaptation](https://www.adaptation-changement-climatique.gouv.fr/) has been launched. This platform, managed by Cerema at the request of the ministry in charge of ecological transition, in partnership with Ademe and Météo-France, offers resources to act against the impacts of climate change, know the solutions for adapting to climate change, and implement concrete actions (examples of best practices).

The ministry in charge of ecological transition organized pilot sessions in 2022 to raise awareness among elected officials about climate change, with a specific focus on adapting to climate change. Training for state agents on ecological transition has also been initiated since 2023 with test training and deployment in 2024. It is planned, moreover, to train all state agents on these issues by 2027. This training will include the issues of adaptation and will address both the aspects related to the functioning of the administration and the measures to be taken in terms of public action.

Météo-France has developed several climate services to help local authorities access local data on the impacts their territory will face [(DRIAS,](https://www.drias-climat.fr/) [DRIAS](https://www.drias-eau.fr/) - water, [Climat HD](https://meteofrance.com/climathd), [Climadiag commune, Climadiag entreprises)](https://meteofrance.com/climadiag-commune).

Météo-France has also begun working on the production of high-resolution regionalized climate simulations (2.5 km) for the French West Indies, Guyana, Réunion, Mayotte, New Caledonia, Wallis and Futuna, and the most populated islands of French Polynesia, which were not previously available. They will allow, in particular, the reference warming trajectory for climate change adaptation (TRACC) to be broken down. The first simulations will be available in the 1st half of 2025, and the ambition is to build a permanent organization to ensure the production of climate data and its regular updating for the four overseas zones, as well as the implementation of similar climate services to those that Météo-France offers for mainland France.

The performance and objectives contract of Météo-France also provides for the implementation of a heatwave vigilance system in overseas territories where it is relevant in terms of public health. This action began in early 2024 with the establishment of a working group with the objective, for each department, of defining the periods conducive to heatwave conditions (cyclone periods in the respective basins: Caribbean, Indian Ocean), identifying in the climatology/previous years periods that may have corresponded to situations of extreme heat (temperature, humidity, wind data, etc.), and cross-referencing these meteorological data with health data. The objective is to have a clearly defined system for operational implementation according to the schedules of the hot periods of the different departments.

### **NEW ACTIONS**

1. Develop climate services by integrating the reference warming trajectory for climate change adaptation (TRACC)

2. Provide awareness tools for local elected officials and training for local authority agents

3. Label engineering firms for carrying out vulnerability studies of territorial climate-air-energy plans (PCAET)

4. Define a common set of no-regret actions in PCAETs

5. Publish a guide on maladaptation for local authorities

6. Support local climate change adaptation by developing advocacy on health-environment-work themes

**ACTION 1**

## Develop climate services by integrating the reference warming trajectory for climate change adaptation (TRACC)

The first step is to **integrate the reference warming trajectory for climate change adaptation into existing climate services** ([DRIAS, DRIAS](https://www.drias-climat.fr/) [water,](https://www.drias-eau.fr/) [Climat HD,](https://meteofrance.com/climathd) [Climadiag commune](https://meteofrance.com/climadiag-commune), [Climadiag entreprises,](https://meteofrance.com/climadiag-entreprise) etc.) so that they present their results by level of warming of the TRACC (+2°C in 2030, +2.7°C in 2050, and +4°C in 2100 in mainland France compared to the pre-industrial era). This work has already begun, and the data provided by Météo-France on DRIAS, Climadiag commune, and Climadiag entreprises are already available by level of warming of the TRACC. It is also a matter of continuing the development of these tools and making them more ergonomic and precise to facilitate the use of end users. It is also essential to continue communicating about the added value of climate services to maximize their use.

A **national impacts portal**, developed by Météo-France, will be created by the end of 2026. It will provide all adaptation actors with the data and impact analyses carried out by the various national actors, beyond the sole climate projection data. These data and impact analyses will be enriched beyond 2026. This portal can be fed by the data from regional climate observatories and regional expert groups working on more precise local data, including on the issue of adaptation, as well as with links to resources that present the advantages of nature-based solutions.

|PILOTS|DGEC and Météo-France|
|---|---|
|BUDGET|To be defined|
|SCHEDULE|2025: Specifications of the new DRIAS-impacts service and associated organization, design and start of developments, governance of the action 2026: Continuation and finalization of developments, integration of the first impact data sets|
|INDICATORS|- Number of climate services integrating the TRACC: target of 100% by the end of 2025 - Number of climate service users - Number of themes covered by DRIAS-impacts|

**ACTION 2**

## Provide awareness tools for local elected officials and training for local authority agents

A pilot session was developed by the ministry in charge of ecological transition for an introduction to climate change and its issues, and tested in three departments. It is now a matter of generalizing the work undertaken by including data on future climate according to the TRACC.

All mayors and local elected officials will be able to benefit from awareness sessions on climate and biodiversity issues, adapted to local issues, based on the resources of public expert establishments (Cerema, Ademe, Météo-France, French Office for Biodiversity). These sessions will allow them to strengthen their knowledge of the expected impacts at the territorial level, to appropriate the means of adapting their community to the future context, and to exchange with peers to mutualize best practices as well as their questions.

To help local authority agents to develop their skills on the subject of adaptation, it is planned, in 2025, to establish a partnership with the National Center for Territorial Public Service (CNFPT) to offer dedicated training. Depending on the orientations retained in the Regional Health and Environment Plans, this training can also be part of the dynamic of raising awareness of environmental health issues.

Specific training sessions for elected officials-technicians pairs will allow them to share their results and benefit from these feedbacks to explain their approaches to their colleagues and/or in municipal council.

The prefectural corps will also be offered content on adapting to climate change, as part of the sessions organized jointly by the Institute of Higher Studies of the Ministry of the Interior (IHEMI) and the ministry in charge of ecological transition.

|PILOT|DGEC|
|---|---|
|BUDGET|To be defined|
|SCHEDULE|2024-2026 for elected officials 2025-2027 for the training of all state and local authority agents|
|INDICATORS|- Number of mayor awareness sessions organized in the departments - Number of local elected officials raised awareness - Number of territorial agents trained - Number of state agents trained|

**ACTION 3**

## Label engineering firms for carrying out vulnerability studies of territorial climate-air-energy plans (PCAET)

In the diagnostic phase of the PCAET, intermunicipalities must produce a vulnerability study of their territory, essential for knowing and analyzing the future impacts of global warming and drafting an action plan to adapt their strategy to these vulnerabilities. Due to limited internal engineering, they often call on engineering firms to carry out these vulnerability analyses. However, these analyses can be very heterogeneous in quality. Labeling engineering firms for carrying out vulnerability analyses will make it possible to produce better quality PCAETs, responding to a global weakness of the adaptation components of these plans, in order to improve the resilience of our territories and to ensure that the issues of other crises (biodiversity, resources) are taken into account. In the long term, engineering aid from the Green Fund could be conditional on the use of a labeled engineering firm.

|PILOT|DGEC, in liaison with Ademe, Cerema, and DREAL|
|---|---|
|BUDGET|To be defined|
|SCHEDULE|2025: Definition of the terms of reference 2026: First labels|
|INDICATOR|Number of labeled engineering firms|

**ACTION 4**

## Define a common set of no-regret actions in PCAETs

The analysis of PCAETs adopted by intermunicipalities demonstrates a predominance of energy and mitigation themes, and a weaker treatment of the adaptation theme, with in particular the difficulty for communities to translate the vulnerability study into concrete actions. The objective of the set of actions is to accelerate the preparation of territories for the most significant impacts, with measures relevant to all territories and regardless of the level of warming. When adopting or revising PCAETs coming to the end of their term, defining a set of actions is an opportunity to guide communities on the adaptation actions to include in their plan. Each action will be associated with an indicator, which will also facilitate the reporting of adaptation actions at the national level.

The first action tracks for the set mentioned in the PNACC communities working group are:

   - Carrying out a diagnosis of urban heat islands;

   - Inventory of cool islands and public fountains;

   - Study of cold needs;

   - Study of the possibilities of implementing nature-based adaptation solutions, in particular:

      - Deimpermeabilization and greening of public buildings, starting with schoolyards,

      - Drawing up a rainwater management scheme,

      - Maintaining existing natural areas and biological diversification of natural areas,

      - Plan for renaturing urban environments,

      - Increasing the canopy in the city,

   - Fighting water leaks;

   - Integrating heatwaves into (inter)municipal safety plans;

   - Integrating summer comfort into the specifications of rolling stock;

   - Integrating summer comfort issues into the design of roads and parking (cycle paths, pedestrian paths, parking lots, carpooling areas, etc.) with greening at several levels of height and/or canopies, and permeable coverings with high albedo as soon as possible;

   - Integrating adaptation criteria into the schemes for promoting socially and economically responsible public procurement (SPASER), cf. measure 45 of the PNACC on public procurement.

|PILOT|DGEC|
|---|---|
|BUDGET|No additional need|
|SCHEDULE|2025: Amendment of the PCAET decree|
|INDICATOR|Number of PCAETs integrating the set of actions|

**ACTION 5**

## Publish a guide on maladaptation for local authorities

The High Council for the Climate recommends the publication of a guide on maladaptation, which it defines as an "adaptation action likely to increase negative effects related to climate, in particular *via* an increase in greenhouse gas emissions, an increase or transfer of vulnerability, the aggravation of injustices or even a decrease in well-being, now or in the future." Any action that harms biodiversity is also considered maladaptation. The publication of a guide will make it possible to establish a reference framework for evaluating the risks of maladaptation. This guide will include concrete examples indicating the pitfalls to avoid. It will nevertheless have to take all the necessary precautions, because the effectiveness of adaptation policies is very dependent on the territory in which they are implemented and the level of warming reached.

|PILOT|DGEC|
|---|---|
|BUDGET|10 k€|
|SCHEDULE|2025: Publication and dissemination of the guide|
|INDICATOR|Number of downloads of the guide|

**ACTION 6**

## Support local climate change adaptation by developing advocacy on health-environment-work themes

To change practices, training in taking into account the impacts of climate change on health is essential, in the sense of "One Health" by systematically highlighting the co-benefits for health of the actions carried out and practices. To do this, it is necessary to have accessible data. Santé publique France will continue to disseminate knowledge and recommendations to local decision-makers and the population, *via* multiple channels, and work with urban planning actors to raise awareness, in particular by actors involved in the definition of urban or building projects, new or to be rehabilitated, of the impact of these projects on the health of populations. The objective is to acculturate key training or awareness-raising organizations to public health issues, in particular relating to the adaptation of urban and built environments to the protection of health against heat.

|PILOT|DGS|
|---|---|
|BUDGET|To be defined|
|SCHEDULE|Ongoing, in 2024 the theme of adapting to heat has been prioritized|
|INDICATORS|Number per year of exchange days and sharing of evidence-based data on the health impacts of climate change, with different network heads of interest|

**MEASURE 23**

# **Progressively integrating the TRACC into all public planning documents**

|MEASURE CATEGORY|CONTEXT|
|---|---|
|2. Ensuring the resilience of territories, infrastructures, and essential services|The objective of this sheet is to progressively align all strategic documents of local authorities with the reference warming trajectory for climate change adaptation (TRACC) so that future climate is well integrated into local decisions, as they are renewed.|

### **ACTIONS ALREADY UNDERTAKEN**

Since 2018, public cooperation establishments (EPCI) with more than 20,000 inhabitants have been required to adopt a territorial climate-air-energy plan (PCAET). In this context, they must carry out a vulnerability analysis of their territory to the impacts of climate change. The action plan of the PCAET must include an adaptation component.

At the regional level, it is the regional schemes for spatial planning, sustainable development, and territorial equality (SRADDET), the regional schemes for climate, air, and energy (SRCAE), and the SAR (for overseas territories) that define the main objectives for adapting the regional territory.

Local urban plans (PLU), by their positioning at the interface between territorial planning and operational developments, constitute a strategic level of action in adapting to climate change. The urban planning code thus provides that the action of public authorities in the field of urban planning aims, in particular, to achieve the objective of "fighting against climate change and adapting to this change." Moreover, PLUs or PLUIs (intermunicipal) must be compatible with PCAETs.

### **NEW ACTIONS**

1. Engage work with local authorities to define the modalities for introducing the TRACC into all relevant local planning and sectoral documents

2. Propose a "4°C patch" to EPCIs that have just completed their studies based on other warming hypotheses

**ACTION 1**

## Engage work with local authorities to define the modalities for introducing the TRACC into all relevant local planning and sectoral documents

1. In order to be able to refer to it in the various regulations concerned, the TRACC will be introduced by decree into the Environmental Code on the basis of Article 5 of Regulation 2021/1119. This decree will establish the objective, the principle of elaboration of the TRACC and the conditions for its regular review. This decree will also be the vector for integrating the PNACC, whose actions are based on the TRACC scenario, into the regulatory corpus.

2. To act in a coordinated manner at the local level, in line with national planning, the TRACC must be progressively integrated into all relevant local planning and sectoral documents. Thus, local authorities will no longer have to question the climate scenario to be adopted for their adaptation policy and the vulnerability analyses carried out will be harmonized and comparable. Concretely, it will be a matter of modifying the texts governing the content of the documents concerned.

The decree relating to PCAETs will also be amended to better frame what is required of local authorities on the adaptation component, in particular the themes to be addressed. Many PCAETs, valid for six years, will soon enter the revision phase and will thus be able to integrate the TRACC at the time of their renewal.

Local authorities will be able to progressively update these documents, when they are revised.

To help them, they will have access to climate services and will be able to consult the national impacts portal (cf. measure 22 of the PNACC). Data on local climate, produced and provided by Météo-France *via* its platform [DRIAS e](https://www.drias-climat.fr/) and the [Climadiag commune](https://meteofrance.com/climadiag-commune) site are already available by level of warming of the TRACC for mainland France. By the end of 2025, they will also be available for overseas territories.

|PILOT|DGEC, with the support of DGALN and DGCL|
|---|---|
|BUDGET|No additional need|
|SCHEDULE|2025: Publication of the TRACC decree and update of the PCAET decree Integration of the TRACC into planning documents during their revision|

**ACTION 2**

## Propose a "4°C patch" to EPCIs that have just completed their vulnerability studies based on other warming hypotheses

PCAETs are regularly updated, and some communities have just completed the preliminary studies for their development without taking the TRACC as a working hypothesis. In order not to have to start all over again at this advanced stage of the procedure, a "+4°C patch" will be proposed to them with a view to realigning their documents with the TRACC. For example, for PCAETs that have not projected beyond 2050, it will be a matter of verifying whether new risks appear on the territory of the community after 2050 and whether the PCAET action program really allows them to be anticipated or whether adjustments would be desirable.

|PILOT|DGEC, in liaison with Météo-France, Ademe, and Cerema|
|---|---|
|BUDGET|No additional need|
|SCHEDULE|2025|
|INDICATOR|Number of communities integrating the TRACC with the "4°C patch" method: target of covering 100% of communities in the process of revising their PCAET|

**MEASURE 24**

# **Integrating climate change adaptation issues into all technical standards**

|MEASURE CATEGORY|CONTEXT|
|---|---|
|2. Ensuring the resilience of territories, infrastructures, and essential services|The objective of this sheet is to evolve, to take into account the future climate, all technical references and regulations that have a climatic component to guarantee systematic and relevant adaptation to climate change of the sectors concerned (building, urban planning, transport, energy production and transport, networks and infrastructures). Many socio-economic activities are based on technical references or regulations that specify the framework to be respected for their implementation. Many of them have a climatic component, i.e., they specify the climatic conditions in which materials and processes contributing to these activities must be able to function nominally. This may be, for example, ranges of external temperature, intensity of precipitation, wind strength, river flow, weight of snow on roofs, sea level, or wave height. In the past, these technical references and regulations were established on the basis of local climatology, deduced from climatic data observed or analyzed over a period ideally of thirty years. It is therefore necessary to update these standards by taking into account the future climate, in particular for activities based on long-lasting infrastructures or materials, knowing that many of these standards are European, even international.|

### **ACTIONS ALREADY UNDERTAKEN**

A **specific international standard** on the issue of adapting to climate change has been developed (NF EN ISO 14 090 of 2019: adaptation to climate change - principles, requirements, and guidelines) and declined (NF EN ISO 14 091 of 2021: vulnerability, impacts, and risk assessment; NF EN ISO 14 093 of 2023: mechanism for financing adaptation at the local level, 2023). Furthermore, sectoral work on the principles of adapting to climate change has been carried out, in view of the NF ISO 24566-1 standard of 2023 "Adaptation of water services to the impacts of climate change."

A request for standardization from the European Commission on the integration of adaptation to climate change into **European standards** was adopted at the standards committee in December 2023. It is based on the European climate law and the European Union's adaptation strategy of 2021, taken up in the 2022 standardization strategy. It is integrated into the European Union's annual work program on standardization for 2023. The request for standardization includes a list of 350 standards to be revised by the end of 2026.

### **NEW ACTIONS**

1. Draw up an overview of ongoing work on standards to identify gaps in relation to climate change adaptation issues

2. Publish a list of criteria to be systematically taken into account on the occasion of the revision of technical standards

3. Progressively adapt all technical standards and references

**ACTION 1**

## Draw up an overview of ongoing work on standards to identify gaps in relation to climate change adaptation issues

Much work is already underway on standards and other work will arrive very quickly due to the European Commission's request for standardization (cf. "actions already undertaken" section). It is a matter of making an overview and identifying the complementary actions to be taken. Some standards may indeed need to be modified to allow the implementation of adaptation solutions. For example, the standard on buried networks can make it difficult to plant trees in the city and is in the process of being revised.

|PILOT|CGDD, with the support of DGEC and in liaison with AFNOR|
|---|---|
|BUDGET|35,000 €|
|SCHEDULE|1st half of 2025: Drawing up the overview|
|INDICATOR|Submission of the overview|

**ACTION 2**

## Publish a list of criteria to be systematically taken into account on the occasion of the revision of technical standards

These criteria must integrate nature-based solutions for their systemic character, their positive impact on biodiversity, mitigation, and adaptation to climate change, human health. These criteria may be the subject of an international document, based on French ambitions, within the framework of the ISO strategy for reviewing voluntary standards in view of climate considerations.

|PILOT|CGDD, with the support of DGEC and in liaison with AFNOR|
|---|---|
|BUDGET|30,000 €|
|SCHEDULE|By the end of 2025: Submission of the list of criteria|
|INDICATOR|Publication of the list of criteria|

**ACTION 3**

## Progressively adapt all technical standards and references

All technical standards and references will be progressively updated to take into account the future climate, according to the reference warming trajectory for climate change adaptation. Details on the implementation of this measure are provided in the dedicated sectoral sheets:

   - Measures 3, 5, 6, and 7: natural risks and clay swelling-shrinkage

   - Measure 21: water

   - Measure 30: transport

   - Measure 31: energy system

   - Measure 32: telecommunications services

**MEASURE 25**

# **Permanently establishing the "Adaptation Mission," a unified engineering offer from the State for adaptation for local authorities**

|MEASURE CATEGORY|CONTEXT|
|---|---|
|2. Ensuring the resilience of territories, infrastructures, and essential services|The connection with the various State operators must be simplified and facilitated for local authorities, through a coordinated interface, in order to define local diagnostics and adaptation strategies and to initiate adaptation operations, by mobilizing all the skills of these operators, on a case-by-case basis and according to the identified adaptation needs. The implementation of this pathway, called "Adaptation Mission," fully fits into the framework of the implementation of the "charter for public engineering at the service of territories in the success of the ecological transition," signed by the ministry in charge of ecological transition and the operators ANCT, ADEME, CEREMA, ANAH, ANRU, and the Territories Bank, during the mayors' fair in November 2023. The operators have committed to coordinating more effectively and making their national and local engineering offers complementary in the service of the ecological transition of territories, in order to make them more readable and operational, and thus respond as closely and as accurately as possible to the needs of local public actors.|

### **ACTIONS ALREADY UNDERTAKEN**

For about ten years, regional expert groups on climate (GREC) have been set up with the ambition of enlightening the actors of the territories. The GREC provide complementary scientific expertise to the technical expertise offered by the State operators. In total, ten GREC have been identified, mainly in mainland France.

The State operators (ADEME, CEREMA, BRGM, Météo-France, etc.) are beginning to develop services on the theme of adapting to climate change, each in their field of expertise. The emergence and realization of adapted adaptation projects
```