document.getElementById("splitBtn").addEventListener("click", async () => {
  const file = document.getElementById("pdfFile").files[0];
  const numSplits = parseInt(document.getElementById("numSplits").value, 10);

  if (!file || isNaN(numSplits) || numSplits < 1) {
    alert("Merci de sélectionner un fichier PDF et de préciser en combien de paries vous souhaitez le découper.");
    return;
  }

  const arrayBuffer = await file.arrayBuffer();
  const pdfDoc = await PDFLib.PDFDocument.load(arrayBuffer);
  const totalPages = pdfDoc.getPageCount();
  const pagesPerSplit = Math.ceil(totalPages / numSplits);
  const outputDiv = document.getElementById("output");
  outputDiv.innerHTML = "";

  for (let i = 0; i < numSplits; i++) {
    const newPdf = await PDFLib.PDFDocument.create();
    const start = i * pagesPerSplit;
    const end = Math.min(start + pagesPerSplit, totalPages);
    const copiedPages = await newPdf.copyPages(pdfDoc, [...Array(end - start).keys()].map(k => k + start));
    copiedPages.forEach(p => newPdf.addPage(p));
    
    const pdfBytes = await newPdf.save();
    const blob = new Blob([pdfBytes], { type: 'application/pdf' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.href = url;
    a.download = `pdf_partie-${i + 1}.pdf`;
    a.textContent = `Télécharger pdf_partie ${i + 1}`;
    a.target = "_blank";
    outputDiv.appendChild(a);
    outputDiv.appendChild(document.createElement("br"));
  }
});